clear
set more off
capture log close
version 14

global ip9eul "D:\Home\aejack\Data\IP\IP1-9-EUL\stata13_se"
global j "D:\Home\aejack\Research\NewTechnologies\TillReceiptScanning\junk2"



* Participation in Spending Study 1
************************************

* count number of IP9 respondents
use $ip9eul/i_indresp_ip, clear
tab i_ivfio

* count number of app uses recorded in the paradata
use $j/cr-7, clear
keep if eligible==1
keep if everapp==1
keep if ip9==1
count


* Open analysis file
use $j/cr-7, clear

svyset i_psu, strata(i_strata)

bysort pidp (starttime): keep if _n==1

* drop those found ineligible for the spending study
drop if eligible==0
tab eligible

* number of people invited to spending study
count

* app download / scanning by IP9 non-respondents:
recode ip9outcome (1=1 "respondent") (0 = 2 "non-respondent"), gen(ip9)

tab ip9 download_dv, row mis
tab ip9 everapp_dv, row miss

* drop IP9 non-respondents
tab ip9
tab ip9, nolab
keep if ip9==1

* count number of IP9 respondents invited to the spending study
count

* end of project survey response rate
tab everapp eopoutcome, row

* mode of IP9 interview:
tab i_indmode

* self-completion not completed
tab i_indmode nosc, miss

* number of IP9 respondents who reported not having a mobile device who used the app
tab smtab_dv everapp_dv, row


* RQ1: Outcomes & effect of bonus on outcomes
***********************************************

* whether answered mobile device questions
tab smtabmiss, miss
tab smtabmiss i_indmode, miss // 26 CATI Respondents
tab smtabmiss i_scflagip9, miss //  CAPI respondents who declined CASI

* whether downloaded app
tab download_dv

* scanned at least one receipt
tab everapp_dv

* scanned at least once in each of 5 consecutive weeks
tab week5_dv

* effect of bonus
svy: tab incent download_dv, row percent
svy: tab incent everapp_dv, row percent
svy: tab incent week5_dv, row percent

* outcomes conditional on having a device
tab download_dv if smtabmiss==1
tab everapp_dv if smtabmiss==1
tab week5_dv if smtabmiss==1

* 15 cases who did not report having a mobile device but did participate
tab smtabmiss everapp_dv, miss


exit



